let activeIndependentFilter = null;
let activeChainFilter = null;
let activeIndependentButton = null;
let activeChainButton = null;
let fullData = null;

function showError(message) {
  const statusBox = document.getElementById("status-message");
  statusBox.textContent = message;
  statusBox.classList.remove("hidden");
}

function renderResults(data) {
  fullData = data;
  const statusBox = document.getElementById("status-message");
  statusBox.classList.add("hidden");
  const nav = document.getElementById("nav");

  const listContainer = document.getElementById("restaurant-list");
  listContainer.innerHTML = "";

  const toggleBar = document.createElement("div");
  toggleBar.className = "flex justify-center gap-4 mb-6";

  const btnIndependent = document.createElement("button");
  btnIndependent.textContent = "Independent Restaurants";
  btnIndependent.className = "bg-white text-black px-6 py-2 rounded-full font-semibold shadow hover:shadow-lg transition";

  const btnChains = document.createElement("button");
  btnChains.textContent = "Chain Restaurants";
  btnChains.className = "bg-gray-300 text-black px-6 py-2 rounded-full font-semibold hover:shadow-lg transition";

  toggleBar.prepend(btnIndependent);
  toggleBar.appendChild(btnChains);
  listContainer.appendChild(toggleBar);

  const independentData = data.cuisines || {};
  const chainData = groupChainsByCuisine(data.chains || []);

  const independentSection = createFilterableSection("Independent Restaurants", independentData, false);
  const chainSection = createFilterableSection("Chain Restaurants", chainData, true);

  independentSection.classList.add("block");
  chainSection.classList.add("hidden");

  btnIndependent.onclick = () => {
    independentSection.classList.remove("hidden");
    chainSection.classList.add("hidden");

    btnIndependent.classList.replace("bg-gray-300", "bg-white");
    btnChains.classList.replace("bg-white", "bg-gray-300");
  };

  btnChains.onclick = () => {
    independentSection.classList.add("hidden");
    chainSection.classList.remove("hidden");

    btnIndependent.classList.replace("bg-white", "bg-gray-300");
    btnChains.classList.replace("bg-gray-300", "bg-white");
  };

  listContainer.appendChild(independentSection);
  listContainer.appendChild(chainSection);
}

function groupChainsByCuisine(chains) {
  const grouped = {};
  chains.forEach(place => {
    const cuisine = getCuisine(place.types, place.name);
    if (!grouped[cuisine]) grouped[cuisine] = [];
    grouped[cuisine].push(place);
  });
  return grouped;
}

function createFilterableSection(title, cuisineMap, isChain) {
  const wrapper = document.createElement("div");
  wrapper.className = "bg-white/10 backdrop-blur-md rounded-2xl p-6 my-6 shadow-md";

  const heading = document.createElement("h2");
  heading.className = "text-2xl font-bold text-white mb-4";
  heading.textContent = title;
  wrapper.appendChild(heading);

  const buttonRow = document.createElement("div");
  buttonRow.className = "flex flex-wrap gap-3 mb-6 inner-button-row";
  wrapper.appendChild(buttonRow);

  const resultsArea = document.createElement("div");
  resultsArea.className = "grid gap-4 sm:grid-cols-2 md:grid-cols-2 lg:grid-cols-3 result";
  wrapper.appendChild(resultsArea);

  const placeholderMessage = document.createElement("p");
  placeholderMessage.textContent = "Please Select a Cuisine to View Restaurants.";
  placeholderMessage.className = "text-white mb-4 select-nu msgcheck";
  wrapper.appendChild(placeholderMessage);

  const buttonMap = isChain
    ? groupChainsByCuisine(fullData.chains || [])
    : fullData.cuisines;

  cuisineList.forEach((cuisine) => {
    const itali = document.createElement("img");
    itali.src = "assets/Italian.png";
    itali.alt = "Cutlery";
    itali.style.width = "36px";
    itali.style.height = "36px";
    itali.style.display = "inline-block";
    itali.style.verticalAlign = "middle";
    itali.style.marginRight = "4px";

    const indi = document.createElement("img");
    indi.src = "assets/dosa.png";
    indi.alt = "Cutlery";
    indi.style.width = "36px";
    indi.style.height = "36px";
    indi.style.display = "inline-block";
    indi.style.verticalAlign = "middle";
    indi.style.marginRight = "4px";

    const japane = document.createElement("img");
    japane.src = "assets/japan.png";
    japane.alt = "Cutlery";
    japane.style.width = "36px";
    japane.style.height = "36px";
    japane.style.display = "inline-block";
    japane.style.verticalAlign = "middle";
    japane.style.marginRight = "4px";

    const mexic = document.createElement("img");
    mexic.src = "assets/tacos.png";
    mexic.alt = "Cutlery";
    mexic.style.width = "36px";
    mexic.style.height = "36px";
    mexic.style.display = "inline-block";
    mexic.style.verticalAlign = "middle";
    mexic.style.marginRight = "4px";

    const briti = document.createElement("img");
    briti.src = "assets/apple-pie.png";
    briti.alt = "Cutlery";
    briti.style.width = "36px";
    briti.style.height = "36px";
    briti.style.display = "inline-block";
    briti.style.verticalAlign = "middle";
    briti.style.marginRight = "4px";

    const chine = document.createElement("img");
    chine.src = "assets/dimsum.png";
    chine.alt = "Cutlery";
    chine.style.width = "36px";
    chine.style.height = "36px";
    chine.style.display = "inline-block";
    chine.style.verticalAlign = "middle";
    chine.style.marginRight = "4px";

    const kore = document.createElement("img");
    kore.src = "assets/pasta.png";
    kore.alt = "Cutlery";
    kore.style.width = "36px";
    kore.style.height = "36px";
    kore.style.display = "inline-block";
    kore.style.verticalAlign = "middle";
    kore.style.marginRight = "4px";

    const spani = document.createElement("img");
    spani.src = "assets/paella.png";
    spani.alt = "Cutlery";
    spani.style.width = "36px";
    spani.style.height = "36px";
    spani.style.display = "inline-block";
    spani.style.verticalAlign = "middle";
    spani.style.marginRight = "4px";

    const fren = document.createElement("img");
    fren.src = "assets/french-toast.png";
    fren.alt = "Cutlery";
    fren.style.width = "36px";
    fren.style.height = "36px";
    fren.style.display = "inline-block";
    fren.style.verticalAlign = "middle";
    fren.style.marginRight = "4px";

    const europe = document.createElement("img");
    europe.src = "assets/europe.png";
    europe.alt = "Cutlery";
    europe.style.width = "36px";
    europe.style.height = "36px";
    europe.style.display = "inline-block";
    europe.style.verticalAlign = "middle";
    europe.style.marginRight = "4px";

    const pizz = document.createElement("img");
    pizz.src = "assets/pizza-slices.png";
    pizz.alt = "Cutlery";
    pizz.style.width = "36px";
    pizz.style.height = "36px";
    pizz.style.display = "inline-block";
    pizz.style.verticalAlign = "middle";
    pizz.style.marginRight = "4px"

    const hambur = document.createElement("img");
    hambur.src = "assets/burger.png";
    hambur.alt = "Cutlery";
    hambur.style.width = "32px";
    hambur.style.height = "32px";
    hambur.style.display = "inline-block";
    hambur.style.verticalAlign = "middle";
    hambur.style.marginRight = "4px";

    const othe = document.createElement("img");
    othe.src = "assets/salad.png";
    othe.alt = "Cutlery";
    othe.style.width = "36px";
    othe.style.height = "36px";
    othe.style.display = "inline-block";
    othe.style.verticalAlign = "middle";
    othe.style.marginRight = "4px";

    const btn = document.createElement("button");
    btn.className = "bg-white text-black rounded-full px-4 py-1 text-sm font-semibold transition hover:bg-gray-200";
    btn.textContent = cuisine.charAt(0).toUpperCase() + cuisine.slice(1);

    if(cuisine.charAt(0).toUpperCase() + cuisine.slice(1) == "Italian"){
      btn.prepend(itali);
    }else if(cuisine.charAt(0).toUpperCase() + cuisine.slice(1) == "Indian"){
      btn.prepend(indi);
    }else if(cuisine.charAt(0).toUpperCase() + cuisine.slice(1) == "Japanese"){
      btn.prepend(japane);
    }
    else if(cuisine.charAt(0).toUpperCase() + cuisine.slice(1) == "Mexican"){
      btn.prepend(mexic);
    }
    else if(cuisine.charAt(0).toUpperCase() + cuisine.slice(1) == "British"){
      btn.prepend(briti);
    }
    else if(cuisine.charAt(0).toUpperCase() + cuisine.slice(1) == "Chinese"){
      btn.prepend(chine);
    }
    else if(cuisine.charAt(0).toUpperCase() + cuisine.slice(1) == "Korean"){
      btn.prepend(kore);
    }
    else if(cuisine.charAt(0).toUpperCase() + cuisine.slice(1) == "Spanish"){
      btn.prepend(spani);
    }
    else if(cuisine.charAt(0).toUpperCase() + cuisine.slice(1) == "French"){
      btn.prepend(fren);
    }
    else if(cuisine.charAt(0).toUpperCase() + cuisine.slice(1) == "European"){
      btn.prepend(europe);
    }
    else if(cuisine.charAt(0).toUpperCase() + cuisine.slice(1) == "Pizza"){
      btn.prepend(pizz);
    }
    else if(cuisine.charAt(0).toUpperCase() + cuisine.slice(1) == "Hamburger"){
      btn.prepend(hambur);
    }
    else if(cuisine.charAt(0).toUpperCase() + cuisine.slice(1) == "Other"){
      btn.prepend(othe);
    }

    btn.onclick = async () => {
      const result = wrapper.querySelector(".result");
      const message = wrapper.querySelector(".msgcheck");
      if (message) {
        message.remove();
      }
      result.classList.remove("hidden");

      const innerButtonRow = wrapper.querySelector(".inner-button-row");
      if (innerButtonRow) {
        innerButtonRow.style.display = "none";
      }

      let backButton = wrapper.querySelector("#back-to-filters");
      if (!backButton) {
        backButton = document.createElement("button");
        backButton.id = "back-to-filters";
        backButton.textContent = "← Back to Filters";
        backButton.className = "mb-4 ml-6 px-4 py-2 bg-gray-200 text-black rounded hover:bg-gray-300 transition";

        backButton.onclick = () => {
          innerButtonRow.style.removeProperty("display");
          result.classList.add("hidden");
          backButton.remove();

          if (isChain) {
            activeChainButton?.classList.remove("ring-2", "ring-black", "bg-gray-100");
          } else {
            activeIndependentButton?.classList.remove("ring-2", "ring-black", "bg-gray-100");
          }
        };

        const reference = document.querySelector(".flex.justify-center.gap-4.mb-6");
        if (reference && backButton) {
          insertAfter(backButton, reference);
        }
      }

      if (isChain) {
        activeChainFilter = cuisine;
        activeChainButton?.classList.remove("ring-2", "ring-black", "bg-gray-100");
        activeChainButton = btn;
      } else {
        activeIndependentFilter = cuisine;
        activeIndependentButton?.classList.remove("ring-2", "ring-black", "bg-gray-100");
        activeIndependentButton = btn;
      }

      btn.classList.add("ring-2", "ring-black", "bg-gray-100");

      try {
        const location = await getUserLocation();
        const list = await fetchNearbyRestaurants(location, cuisine);
        renderRestaurantList(list, resultsArea, isChain);
      } catch (error) {
        // Pass the wrapper to the modal function so it can target the correct elements
        showNoResultModal(cuisine, wrapper);
        console.error(error);
      }
    };

    buttonRow.appendChild(btn);
  });

  return wrapper;
}
function insertAfter(newNode, referenceNode) {
  referenceNode.parentNode.insertBefore(newNode, referenceNode.nextSibling);
}

// Updated showNoResultModal to accept a wrapper
function showNoResultModal(cuisineName, wrapper) {
  const modal = document.getElementById("noResultModal");
  const message = document.getElementById("modalMessage");
  message.textContent = `❌ No ${cuisineName} restaurants near to you.`;
  modal.classList.remove("hidden");

  // Remove previous listener and add a new one scoped to the current wrapper
  const closeModalBtn = document.getElementById("closeModalBtn");
  const newCloseModalBtn = closeModalBtn.cloneNode(true);
  closeModalBtn.parentNode.replaceChild(newCloseModalBtn, closeModalBtn);
  
  newCloseModalBtn.addEventListener("click", () => {
    const innerButtonRow = wrapper.querySelector(".inner-button-row");
    const backButton = document.querySelector("#back-to-filters");
    const result = wrapper.querySelector(".result");
    
    modal.classList.add("hidden");
    result.classList.add("hidden");
    if(innerButtonRow) {
      innerButtonRow.style.removeProperty("display");
    }
    if(backButton) {
      backButton.remove();
    }
  });
}

function renderRestaurantList(list, container, isChain) {
  container.innerHTML = "";

  if (list.length === 0) {
    const cuisine = activeChainFilter || activeIndependentFilter || "selected";
    // Find the correct wrapper to pass to the modal
    const wrapper = container.closest('.bg-white/10');
    showNoResultModal(cuisine, wrapper);
    return;
  }

  const filteredList = list.filter(place => isChain === chainList.some(chain => place.name.toLowerCase().includes(chain)));

  if (filteredList.length === 0) {
    const cuisine = activeChainFilter || activeIndependentFilter || "selected";
    // Find the correct wrapper to pass to the modal
    const wrapper = container.closest('.bg-white/10');
    showNoResultModal(cuisine, wrapper);
    return;
  }

  filteredList.forEach(place => {
    const card = document.createElement("div");
    card.className = "bg-white text-black p-4 rounded-2xl shadow-md hover:shadow-xl transition";

    const nameImg = document.createElement("img");
    nameImg.src = "assets/spoon.png";
    nameImg.alt = "Cutlery";
    nameImg.style.width = "16px";
    nameImg.style.height = "16px";
    nameImg.style.display = "inline-block";
    nameImg.style.verticalAlign = "middle";
    nameImg.style.marginRight = "4px";

    const rating = document.createElement("p");
    rating.className = "text-sm italic mb-2";
    if (place.rating) {
      const starImg = document.createElement("img");
      starImg.src = "assets/star.png";
      starImg.alt = "Star";
      starImg.style.width = "12px";
      starImg.style.height = "12px";
      starImg.style.display = "inline-block";
      starImg.style.verticalAlign = "middle";
      starImg.style.marginRight = "4px";

      rating.appendChild(starImg);
      rating.append(` ${place.rating}`);
    } else {
      rating.textContent = "No rating";
    }

    const name = document.createElement("h2");
    name.className = "font-bold text-lg mb-1";
    name.textContent = place.name;

    const nameWrapperdetails = document.createElement("div");
    nameWrapperdetails.className = "name-img-di-details";
    nameWrapperdetails.appendChild(nameImg);
    nameWrapperdetails.appendChild(name);

    const nameWrapper = document.createElement("div");
    nameWrapper.className = "name-img-di";
    nameWrapper.appendChild(nameWrapperdetails);
    nameWrapper.appendChild(rating);

    const addressImg = document.createElement("img");
    addressImg.src = "assets/location.png";
    addressImg.alt = "Cutlery";
    addressImg.style.width = "14px";
    addressImg.style.height = "14px";
    addressImg.style.display = "inline-block";
    addressImg.style.verticalAlign = "middle";
    addressImg.style.marginRight = "4px";

    const address = document.createElement("p");
    address.className = "text-sm mb-1";
    address.textContent = place.vicinity;

    address.prepend(addressImg);

    const link = document.createElement("a");
    link.className = "inline-block px-4 py-1 bg-blue-600 text-white rounded-full shadow hover:bg-blue-700 transition";
    link.href = `https://www.google.com/maps/place/?q=place_id:${place.place_id}`;
    link.target = "_blank";
    link.textContent = "Direction";

    card.append(nameWrapper, address, link);
    container.appendChild(card);
  });
}