 // geo.js - Geolocation and restaurant fetcher

function getUserLocation() {
  return new Promise((resolve, reject) => {
    if (!navigator.geolocation) return reject(new Error("Geolocation not supported"));

    navigator.geolocation.getCurrentPosition(
      (pos) => {
        resolve({
          lat: 51.7500653,
          lng: -0.3445277,
        });
      },
      () => reject(new Error("Oops, something went wrong. Please try again."))
    );
  });
}

// Pass cuisine as a parameter
function fetchNearbyRestaurants({ lat, lng }, cuisine) {
  return new Promise((resolve, reject) => {
    const map = new google.maps.Map(document.createElement('div'));
    const service = new google.maps.places.PlacesService(map);
    let keywords="";
        if (cuisine == "Other"){
            keywords=`"restaurant",  "food",  "fast food",  "bakery",  "cafe",  "meal_takeaway",  "supermarket",  "convenience_store",  "liquor_store",  "bar",  "night_club",  "brewery",  "catering",  "meal_delivery",  "street_food",  "market",  "wine_store", "bbq_restaurant",  "breakfast_restaurant",  "brunch_restaurant",  "greek_restaurant",  "hamburger_restaurant",  "ice_cream_shop",  "mediterranean_restaurant",  "ramen_restaurant", "seafood_restaurant",  "steak_house",  "sushi_restaurant","bistro",  "deli",  "farmers_market",  "gourmet_food_store",  "health_food_store",  "tea_house",  "patisserie"`
        }else{
            keywords=`${cuisine} restaurants`
        }

    const request = {
      location: { lat, lng },
      radius: 1609.34,
    //   type: 'restaurant',
      // Use the cuisine parameter to filter the search
      keyword: keywords
    };

    service.nearbySearch(request, (results, status) => {
      if (status === google.maps.places.PlacesServiceStatus.OK) {
        resolve(results);
      } else {
        // Change the rejection message to be more specific
        reject(new Error(`No ${cuisine} restaurants found within 1 mile.`));
      }
    });
  });
}
