function isChain(name) {
  if (!name) return false;
  const lowerName = name.toLowerCase().replace(/[^\w\s]/gi, '');

  return chainList.some(chain => {
    const normalizedChain = chain.toLowerCase().replace(/[^\w\s]/gi, '');
    const pattern = new RegExp(`\\b${normalizedChain}\\b`, 'i');
    return pattern.test(lowerName);
  });
}

function getCuisine(types, name = "") {
  const lowerName = name.toLowerCase();

  for (let cuisine of cuisineList) {
    if (lowerName.includes(cuisine)) return cuisine;
  }

  const keywordMap = {
    pizza: "pizza",
    biryani: "indian", kottu: "indian", tandoori: "indian", taj: "indian",
    shawarma: "middle eastern", hummus: "middle eastern", kebab: "middle eastern",
    burger: "hamburger", grill: "hamburger", "fried chicken": "hamburger",
    sushi: "japanese", ramen: "japanese",
    noodle: "chinese", wok: "chinese",
    roti: "indian", kamu: "indian",
    paella: "spanish", tapas: "spanish",
    curry: "indian", masala: "indian",
    kimchi: "korean", bibimbap: "korean",
    croissant: "french", baguette: "french",
    "fish and chips": "british", pub: "british",
    taco: "mexican", burrito: "mexican"
  };

  for (const [key, value] of Object.entries(keywordMap)) {
    if (lowerName.includes(key)) return value;
  }

  return "other";
}

function processRestaurants(results) {
  const categorized = {
    chains: [],
    cuisines: {},
  };

  results.forEach(place => {
    if (!place.name || !place.types) return;

    if (isChain(place.name)) {
      categorized.chains.push(place);
    } else {
      const cuisine = getCuisine(place.types, place.name);
      if (!categorized.cuisines[cuisine]) categorized.cuisines[cuisine] = [];
      categorized.cuisines[cuisine].push(place);
    }
  });

  renderResults(categorized);
}
