let chainList = [];
let cuisineList = [];

// Load chains and cuisines from external TXT files
async function loadTextLists() {
  const [chains, cuisines] = await Promise.all([
    fetch("data/CHAIN UK.txt").then(res => res.text()),
    fetch("data/CUISINES.txt").then(res => res.text())
  ]);

  chainList = chains
  .split(/\r?\n/)
  .map(name => name.trim().toLowerCase().replace(/[^\w\s]/gi, '')) // remove punctuation
  .filter(Boolean);

  cuisineList = cuisines
    .split(/\r?\n/)
    .map(c => c.trim().toLowerCase())
    .filter(Boolean);

  console.log("Chain List:", chainList);
// console.log("Sample Place Name:", results[0]?.name.toLowerCase());
    
    
}

// Wait for Google Maps API (ensures library is ready before using)
function waitForGoogleMaps(callback) {
  const interval = setInterval(() => {
    if (window.google?.maps?.places) {
      clearInterval(interval);
      callback();
    }
  }, 100);
}

// App entry point
waitForGoogleMaps(async () => {
  console.log("🗺️ Google Maps API loaded.");

  try {
    await loadTextLists();
    
    // Initial UI render with empty data. Restaurants will be fetched on button click.
    renderResults({ chains: [], cuisines: {} });
  } catch (err) {
    console.error("❌ Error:", err);
    showError(err.message);
  }
});